* Do-fil til kapittel 3
use "https://nedlasting.fagbokforlaget.no/stata/abu89.dta", clear
summarize   /* Beskrivende statistikk for alle variablenene*/
tabulate klasse89, missing
tabulate klasse89, plot   /* med enkelt stolpediagram */
tabulate klasse89 if female==0, missing   /* Bare for menn */
graph pie, over(klasse89)   /* Figur 3.2-3 kakediagram */
histogram klasse89, discrete percent gap(10) addlabel  /* Fig 3.5 stolpediagram */
** Fig 3.6 samme stolpediagram, men med prosenter gjengitt med en desimal
histogram klasse89, discrete percent gap(10) addlabopts(yvarformat(%4.1f))
* omkode alder til age6
recode age (16/19=1 16-19)(20/29=2 20-29)(30/39=3 30-39)(40/49=4 40-49) ///
(50/59=5 50-59)(60/74=6 60-74), gen(age6)
label variable age6 "Alder i 6 kategorier"
* Figur 3.7 stolpediagram for alder i 6 kategorier
histogram age6, discrete percent gap(10)addlabopts(yvarformat(%4.0f))
** Histogram for alder 
histogram age, bin(12) percent   /* Figur 3.8 */
* Histogram for timelønn  
histogram time89, bin(25) percent
* med normalfordelingskurve
histogram time89, bin(25) percent normal  /* Figur 3.9 */
* Figur 3.10 boksdigram for timelønn
graph box time89 
* Figur 3.11 boksdigram for timelønn etter samfunnsklasse
graph box time89, over(klasse89)
summarize age time89, detail
* alternativ til summarize
tabstat age time89, statistics(min max mean median range ///
var sd p25 p75 skewness kurtosis ) format(%9.2f)
* test for avvik fra normalitet basert på skjevhet og kurtosis
sktest age
* Shapiro-Wilks W test av det samme
swilk age
*standardisering av time89
egen float ztime89 = std(time89), mean(0) std(1)
summ time89 ztime89
